@extends('admin.layout.template')

@section('title','Edit Role')

@section('content')

<div class="page-content">
    <div class="container-xxl">

        <form method="POST" action="{{ route('roles.update', $role->id) }}">
            @csrf
            @method('PUT')

            {{-- Role Info --}}
            <div class="card mb-4">
                <div class="card-header">
                    <h4>Edit Role</h4>
                </div>
                <div class="card-body row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Role Name</label>
                        <input type="text"
                               name="role_name"
                               class="form-control"
                               value="{{ old('role_name', $role->name) }}"
                               required>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Departments</label>
                        <select name="department_ids[]" class="form-select" multiple data-choices required>
                            @foreach($departments as $dept)
                                <option value="{{ $dept->id }}"
                                    {{ in_array($dept->id, $roleDepartmentIds) ? 'selected' : '' }}>
                                    {{ $dept->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-12 mt-2">
                        <div class="form-check">
                            <input type="checkbox"
                                   name="is_locked"
                                   class="form-check-input"
                                   id="is_locked"
                                   {{ $role->is_locked ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_locked">
                                Lock this role (System Role)
                            </label>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Permissions --}}
            @foreach($permissions as $module => $perms)
            <div class="card mb-3 p-3">

                <div class="d-flex justify-content-between mb-2">
                    <h4 class="text-lg font-semibold text-blue-600">
                        {{ ucfirst($module) }}
                    </h4>
                    <div class="form-check">
                        <input type="checkbox"
                               class="form-check-input select-all"
                               data-module="{{ $module }}">
                        <label class="form-check-label">Select All</label>
                    </div>
                </div>

                <div class="row fw-semibold border-bottom pb-2 mb-2">
                    <div class="col-4">Module</div>
                    <div class="col-2 text-center">Add</div>
                    <div class="col-2 text-center">View</div>
                    <div class="col-2 text-center">Update</div>
                    <div class="col-2 text-center">Delete</div>
                </div>

                @php
                    $actions = ['add','view','update','delete'];

                    $actionAliases = [
                        'add'    => ['add','create','store'],
                        'view'   => ['view','index','show'],
                        'update' => ['update','edit'],
                        'delete' => ['delete','destroy'],
                    ];

                    $normalize = fn($v) => strtolower(str_replace(['-','.','_'],'',$v));
                @endphp

                <div class="row align-items-center py-2 permission-row">
                    <div class="col-4 text-capitalize fw-semibold">
                        {{ str_replace('-', ' ', $module) }}
                    </div>

                    @foreach($actions as $action)
                        @php
                            $permissionName = null;

                            $moduleVariants = [$module, \Illuminate\Support\Str::plural($module)];

                            foreach ($perms as $perm) {
                                $permNorm = $normalize($perm);

                                foreach ($moduleVariants as $mod) {
                                    $modNorm = $normalize($mod);

                                    if (!str_contains($permNorm, $modNorm)) continue;

                                    foreach ($actionAliases[$action] as $alias) {
                                        if (str_contains($permNorm, $normalize($alias))) {
                                            $permissionName = $perm;
                                            break 3;
                                        }
                                    }

                                    if (
                                        $action === 'view' &&
                                        ($permNorm === $modNorm || str_ends_with($perm, '.index'))
                                    ) {
                                        $permissionName = $perm;
                                        break 2;
                                    }
                                }
                            }
                        @endphp

                        <div class="col-2 text-center">
                            @if($permissionName)
                                <input type="checkbox"
                                    class="form-check-input permission-checkbox module-{{ $module }}"
                                    name="permissions[]"
                                    value="{{ $permissionName }}"
                                    {{ in_array($permissionName, $rolePermissions) ? 'checked' : '' }}>
                            @endif
                        </div>
                    @endforeach
                </div>

                {{-- Data Scope --}}
                @php
                    $scope = $roleScopes[$module] ?? ['scope_type' => 'all', 'scope_value' => []];
                @endphp

                <div class="row mt-3">
                    <div class="col-md-6">
                        <label class="form-label">Data Access Scope</label>
                        <select name="scopes[{{ $module }}][scope_type]"
                                class="form-select scope-type"
                                data-module="{{ $module }}">
                            @foreach(['all','assigned_location','assigned_franchise','assigned_dealer','own_only'] as $type)
                                <option value="{{ $type }}"
                                    {{ $scope['scope_type'] === $type ? 'selected' : '' }}>
                                    {{ ucwords(str_replace('_',' ',$type)) }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>

            </div>
            @endforeach

            <div class="text-end mb-5">
                <button type="submit" class="btn btn-primary">
                    Update Role
                </button>
            </div>
        </form>
    </div>
</div>

{{-- JS --}}
<script>
    document.querySelectorAll('.select-all').forEach(el => {
        el.addEventListener('change', function () {
            document.querySelectorAll('.module-' + this.dataset.module)
                .forEach(cb => cb.checked = this.checked);
        });
    });
</script>

@endsection
